package gov.va.vinci.dart.dms.biz;

import java.util.List;

import gov.va.vinci.dart.common.SingletonShim;
import gov.va.vinci.dart.common.test.BusinessIntegrationTest;
import gov.va.vinci.dart.biz.DartRequest;
import gov.va.vinci.dart.biz.DocumentTemplate;
import gov.va.vinci.dart.biz.ResearchStudy;
import gov.va.vinci.dart.service.DartObjectFactory;

import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class TestLabel extends BusinessIntegrationTest {
	@BeforeTest
	public void setup() {
		SingletonShim.getBean(DartObjectFactory.class);
	}

	@Test
	public void testOne() throws Exception {
		ResearchStudy.findById(1);
		Document.findById(1);

		List<DartRequest> reqList = DartRequest.listAll();
		Assert.assertNotNull(reqList);
		Assert.assertTrue(reqList.size() > 0);

		DartRequest req = reqList.get(0);
		Assert.assertNotNull(req);
		Assert.assertTrue(req.getId() > 0);
	
		List<DocumentTemplate> dtList = DocumentTemplate.listAll();
		Assert.assertNotNull(dtList);
		Assert.assertTrue(dtList.size() > 0);

		DocumentTemplate dt = dtList.get(0);
		Assert.assertNotNull(dt);

		Document doc = Document.create(req, dt, "DNS");
		Assert.assertNotNull(doc);
		Assert.assertTrue(doc.getId() > 0);
		
		Label lbl = Label.create(doc, "VALUE");
		Assert.assertNotNull(lbl);
		Assert.assertEquals(lbl.getDocument(), doc);
		
		Label lbl2 = Label.findById(lbl.getId());
		Assert.assertNotNull(lbl2);
		Assert.assertEquals(lbl2, lbl);

		lbl.delete();

		Label lbl3 = Label.findById(lbl.getId());
		Assert.assertNull(lbl3);

	}

	@Test
	public void testTwo() throws Exception {
		ResearchStudy.findById(1);
		Document.findById(1);
		
		List<DartRequest> reqList = DartRequest.listAll();
		Assert.assertNotNull(reqList);
		Assert.assertTrue(reqList.size() > 0);

		DartRequest req = reqList.get(0);
		Assert.assertNotNull(req);
		Assert.assertTrue(req.getId() > 0);
	
		List<DocumentTemplate> dtList = DocumentTemplate.listAll();
		Assert.assertNotNull(dtList);
		Assert.assertTrue(dtList.size() > 0);

		DocumentTemplate dt = dtList.get(0);
		Assert.assertNotNull(dt);

		Document doc = Document.create(req, dt, "DNS");
		Assert.assertNotNull(doc);
		Assert.assertTrue(doc.getId() > 0);
		
		Label lbl = Label.create(doc, "CURRENT");
		Assert.assertNotNull(lbl);
		Assert.assertTrue(lbl.getId() > 0);
		Assert.assertEquals(lbl.getDocument(), doc);

		Label lbl2 = Label.create(doc, "ANOTHER");  
		Assert.assertNotNull(lbl);
		Assert.assertTrue(lbl.getId() > 0);
		Assert.assertEquals(lbl.getDocument(), doc);

		Label.deleteAllCurrentLabels(doc.getId());

		Label lbl3 = Label.findById(lbl.getId());
		Assert.assertNull(lbl3);

		// removing current labels does not kill other labels
		lbl3 = Label.findById(lbl2.getId());
		Assert.assertNotNull(lbl3);
		Assert.assertEquals(lbl3, lbl2);

	}
}
